
//// Ukazka jednoducheho pouziti knihovny - inicializace a cteni dat 1x

VAR_GLOBAL CONSTANT
  DEVICE_COUNT : USINT := 7;
END_VAR

PROGRAM prgMain
  VAR CONSTANT
    IP_Address : STRING := '192.168.1.117:502';
    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
  END_VAR

  VAR
    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;
    Device :     ARRAY [1 .. DEVICE_COUNT] OF TDevice;

    smInit_enable : BOOL := true;
    sm_enable : BOOL;

    smInit : fb_SMInit;
    sm : fb_SMReadData;
    smFini : fb_SMFini;
  END_VAR

  // pocatecni detekce pritomnych zarizeni
  smInit(enable := smInit_enable, ip := IP_Address, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

  IF smInit.done THEN
    smInit_enable := false;
    sm_enable := true;
  END_IF;

  //nacteni zakladnich promennych
  sm(enable := sm_enable, ip := IP_Address, chanCode := chanCode, tcp := tcp, DevInfoPtr := ADR(DeviceInfo), DevPtr := ADR(Device), devCount:= smInit.devCount);

  IF sm.done OR sm.err THEN
    sm_enable := false;
    smFini(tcp := tcp);
  END_IF;

END_PROGRAM


