
//// Ukazka cyklickeho cteni dat - jako priklad 2, navic se opakuje s periodou INTERVAL_TIME

VAR_GLOBAL CONSTANT
  DEVICE_COUNT : USINT := 7;

  INTERVAL_TIME: TIME := T#5s;
END_VAR

PROGRAM prgMain
  VAR CONSTANT
    ip : STRING := '192.168.1.117:502';
    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
  END_VAR

  VAR
    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;
    Device :     ARRAY [1 .. DEVICE_COUNT] OF TDevice;
    DeviceMiB :  ARRAY [1 .. DEVICE_COUNT] OF TDeviceMiB;

    smInit_enable : BOOL := true;
    sm_enable : BOOL;
    smMiB_enable : BOOL;

    Timer : TON;

    smInit : fb_SMInit;
    sm : fb_SMReadData;
    smMiB :fb_SMReadStuderMiBData;
    //smFini : fb_SMFini;
  END_VAR

  // pocatecni detekce pritomnych zarizeni
  smInit(enable := smInit_enable, ip := ip, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

  IF smInit.done THEN
    smInit_enable := false;
    sm_enable := true;
  END_IF;

  //nacteni zakladnich promennych
  sm(enable := sm_enable, ip := ip, chanCode := chanCode, tcp := tcp, DevInfoPtr := ADR(DeviceInfo), DevPtr := ADR(Device), devCount:= smInit.devCount);

  IF sm.done OR sm.err THEN
    sm_enable := false;
    smMiB_enable := true;
  END_IF;

  //nacteni rozsirenych promennych (provede se pouze pro Studer-Innotec zarizeni)
  smMiB(enable := smMiB_enable, ip := ip, chanCode := chanCode, tcp := tcp, DevInfoPtr := ADR(DeviceInfo), DevMiBPtr := ADR(DeviceMiB), devCount:= smInit.devCount);

  IF smMiB.done OR smMiB.err THEN
    smMiB_enable := false;
    Timer(IN := 1, PT := INTERVAL_TIME);
  END_IF;

  Timer();     // timer pro cyklicke vycitani

  IF Timer.Q THEN
    Timer(IN := 0);
    sm_enable := true;
  END_IF;

END_PROGRAM


