
//// Ukazka pouziti funkcniho bloku pro rizeni vykonu

VAR_GLOBAL CONSTANT
  DEVICE_COUNT : USINT := 7;
END_VAR

PROGRAM prgMain
  VAR CONSTANT
    IP_Address : STRING := '192.168.1.117:502';
    slaveID : USINT := 5;              // logicke id zarizeni v SM2-MU, kteremu nastavujeme vykon

    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
    active : BOOL := true;             // TRUE - aktivni vykon, FALSE - jalovy vykon
    read : BOOL := false;              // TRUE - cteni, FALSE - zapis
  END_VAR

  VAR
    pwctrl_value : UINT := 60;         // nastavovan hodnota

    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;

    smInit_enable : BOOL := true;
    smPC_enable : BOOL;

    smInit : fb_SMInit;
    smPC : fb_SMPowerControl;
    smFini : fb_SMFini;
  END_VAR

  // pocatecni detekce pritomnych zarizeni
  smInit(enable := smInit_enable, ip := IP_Address, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

  IF smInit.done THEN
    smInit_enable := false;
    smPC_enable := true;
  END_IF;

  // jednorazove nastaveni vykonu
  smPC(enable := smPC_enable, ip := IP_Address, tcp := tcp, read := read, chanCode := chanCode, pwctrl := pwctrl_value, active := active, DevInfoPtr := ADR(DeviceInfo[slaveID]));

  IF smPC.done THEN
    smPC_enable := false;
    smFini(tcp := tcp);
  END_IF;

END_PROGRAM


