
//// Ukazka nacteni jednoho parametru (detailnejsi popis komunikace viz dokumentace)

VAR_GLOBAL CONSTANT
  DEVICE_COUNT : USINT := 7;
END_VAR

PROGRAM prgMain
  VAR CONSTANT
    IP_Address : STRING := '192.168.1.117:502';
    slaveID : USINT := 1;              // logicke id zarizeni v SM2-MU (zde musi byt id Xtenderu, protoze pracujeme s parametrem 1297)

    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
  END_VAR

  VAR
    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;

    smInit_enable : BOOL := true;
    smPar_enable : BOOL;

    smInit : fb_SMInit;
    smPar : fb_SMReadWriteParameter;
    smFini : fb_SMFini;

    par : TParams;
    res : REAL;
  END_VAR

  // pocatecni detekce pritomnych zarizeni
  smInit(enable := smInit_enable, ip := IP_Address, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

  IF smInit.done THEN
    smInit_enable := false;
    smPar_enable := true;

    par.id := 1297;
    par.pType := PARAM_FLOAT;
    par.cmd := PARAM_READ;
  END_IF;

  //nacteni promenne podle parametru
  smPar(enable := smPar_enable, ip := IP_Address, chanCode := chanCode, tcp := tcp, params := par, DevInfoPtr := ADR(DeviceInfo[slaveID]));

  IF smPar.done THEN
    smPar_enable := false;
    res := par.value;
    smFini(tcp := tcp);
  END_IF;

END_PROGRAM


