(* Upozornen *)
(* Soubor je automaticky regenerovn a vechny rucn modifikace budou ztracen. *)
(* ---------------------------------------------------------------------- *)
(* Generovno pro TC700 *)
(* ********************************************************************** *)
VAR_GLOBAL CONSTANT
  CPU_TYPE   : USINT := 76;
  CPU_CODE   : UINT  := 1003;
END_VAR

TYPE
  TAIStat : STRUCT
    UNF     : BOOL;
    UNR     : BOOL;
    OVR     : BOOL;
    OVF     : BOOL;
    FLS     : BOOL;
    CJC     : BOOL;
    dummy6 {HIDDEN} : BOOL;
    dummy7 {HIDDEN} : BOOL;
    CHC     : BOOL;
    dummy9 {HIDDEN} : BOOL;
    dummy10 {HIDDEN} : BOOL;
    dummy11 {HIDDEN} : BOOL;
    dummy12 {HIDDEN} : BOOL;
    dummy13 {HIDDEN} : BOOL;
    dummy14 {HIDDEN} : BOOL;
    dummy15 {HIDDEN} : BOOL;
  END_STRUCT;

  TAI : STRUCT
    STAT  : TAIStat;
    FS    : INT;
    ENG   : REAL;
    PCT   : REAL;
  END_STRUCT;

  TCHMC_IN : STRUCT
    MCSTAT : BYTE;
    MCERR  : USINT;
    MCPOS  : UDINT;
    MCVEL  : UDINT;
  END_STRUCT;

  TCHMC_OUT : STRUCT
    MCCONT  : BYTE;
    MCCOMM  : USINT;
    MCPAR1  : UDINT;
    MCPAR2  : UDINT;
  END_STRUCT;

  TAO_TC6 : STRUCT
    FS  : INT ;
    ENG  : REAL;
    PCT  : REAL;
  END_STRUCT;

  TBIN_16DIP  : STRUCT
    dummy0 {HIDDEN}: BOOL;
    dummy1 {HIDDEN}: BOOL;
    dummy2 {HIDDEN}: BOOL;
    dummy3 {HIDDEN}: BOOL;
    dummy4 {HIDDEN}: BOOL;
    dummy5 {HIDDEN}: BOOL;
    dummy6 {HIDDEN}: BOOL;
    dummy7 {HIDDEN}: BOOL;
    DIP8  : BOOL;
    DIP9  : BOOL;
    DIP10  : BOOL;
    DIP11  : BOOL;
    DIP12  : BOOL;
    DIP13  : BOOL;
    DIP14  : BOOL;
    DIP15  : BOOL;
  END_STRUCT;

  TBIN_16DI : STRUCT
    DI0  : BOOL;
    DI1  : BOOL;
    DI2  : BOOL;
    DI3  : BOOL;
    DI4  : BOOL;
    DI5  : BOOL;
    DI6  : BOOL;
    DI7  : BOOL;
    DI8  : BOOL;
    DI9  : BOOL;
    DI10  : BOOL;
    DI11  : BOOL;
    DI12  : BOOL;
    DI13  : BOOL;
    DI14  : BOOL;
    DI15  : BOOL;
  END_STRUCT;

  TCNTF_IN : STRUCT
    SCNT : UINT;
    VALA : UDINT;
    VALB : UDINT;
  END_STRUCT;

  TCNTF2_OUT : STRUCT
    CCNT: UINT; 
    SET : UDINT;
    SETB : UDINT;
  END_STRUCT;

  TPWM : STRUCT
    FS  : INT ;
    PCT  : REAL;
  END_STRUCT;

  TBIN_12DOIR : STRUCT
    DO0  : BOOL;
    DO1  : BOOL;
    DO2  : BOOL;
    DO3  : BOOL;
    DO4  : BOOL;
    DO5  : BOOL;
    DO6  : BOOL;
    DO7  : BOOL;
    DO8  : BOOL;
    DO9  : BOOL;
    DO10  : BOOL;
    DO11  : BOOL;
    dummy12 {HIDDEN} : BOOL;
    dummy13 {HIDDEN} : BOOL;
    ENA : BOOL;
    ENB : BOOL;
  END_STRUCT;

  TCHStatistic : STRUCT
    STAT       : USINT;
    ERR        : USINT;
    trueMes    : UDINT;
    falseMes   : UDINT;
  END_STRUCT;

  TETHStatistic_BACnet : STRUCT
    STAT       : USINT;
    ERR        : USINT;
    trueMes    : UDINT;
    falseMes   : UDINT;
  END_STRUCT;

  TETHStatistic_UNI : STRUCT
    STAT       : USINT;
    ERR        : USINT;
    trueMes    : UDINT;
    falseMes   : UDINT;
  END_STRUCT;

  TCHControl : STRUCT
    CONTROL  : UINT;
  END_STRUCT;

  TETHControl_UNI : STRUCT
    CONTROL  : UINT;
  END_STRUCT;

  TUniStat : STRUCT
    DSR    : BOOL;
    CTS    : BOOL;
    dummy1 {HIDDEN} : BOOL;
    TRO    : BOOL;
    RCF    : BOOL;
    ROV    : BOOL;
    TRF    : BOOL;
    ARC    : BOOL;
  END_STRUCT;

  TUniCont : STRUCT
    dummy0 {HIDDEN} : BOOL;
    dummy1 {HIDDEN} : BOOL;
    dummy2 {HIDDEN} : BOOL;
    dummy3 {HIDDEN} : BOOL;
    dummy4 {HIDDEN} : BOOL;
    TRG    : BOOL;
    CLR    : BOOL;
    ACN    : BOOL;
  END_STRUCT;

  TUniSign : STRUCT
    DTR : BOOL;
    RTS : BOOL;
  END_STRUCT;

END_TYPE
(* ********************************************************************** *)
(* ---------------------------------------------------------------------- *)
(* CP-1003 *)
TYPE
  TETHStatistic_UNI0 : STRUCT
    STAT : USINT;
    ERR : USINT;
    trueMes : UDINT;
    falseMes : UDINT;
  END_STRUCT;
END_TYPE

TYPE
  TETHControl_UNI0 : STRUCT
    CONTROL : UINT ;
  END_STRUCT;
END_TYPE

TYPE
  TUNI_ETH1_IN0 : STRUCT
    STAT : TUniStat;
    ERR : USINT;
    NUMR : UINT ;
    DATA : ARRAY [0..259] OF USINT;
  END_STRUCT;
END_TYPE

TYPE
  TUNI_ETH1_OUT0 : STRUCT
    CONT : TUniCont;
    SIGN : TUniSign;
    NUMT : UINT ;
    DATA : ARRAY [0..259] OF USINT;
  END_STRUCT;
END_TYPE

VAR_GLOBAL
  r0_p0_Statistic_CH1  AT %X7500 : TCHStatistic;
  r0_p0_Control_CH1    AT %Y7500 : TCHControl;
  r0_p0_Statistic_ETH1_UNI0 AT %X7640 : TETHStatistic_UNI0;
  r0_p0_Control_ETH1_UNI0 AT %Y7624 : TETHControl_UNI0;
  UNI_ETH1_IN0         : TUNI_ETH1_IN0;
  UNI_ETH1_OUT0        : TUNI_ETH1_OUT0;
(* alias *)
  ETH1_UNI0_IN         AT UNI_ETH1_IN0.DATA;
  ETH1_UNI0_OUT        AT UNI_ETH1_OUT0.DATA;
END_VAR
(* ---------------------------------------------------------------------- *)
(* IR-1062 *)
VAR_GLOBAL
  r0_p3_DI             AT %X0   : TBIN_16DI;
  r0_p3_DIP            AT %X2   : TBIN_16DIP;
  r0_p3_CNT_IN1        AT %X4   : TCNTF_IN;
  r0_p3_CNT_IN2        AT %X14  : TCNTF_IN;
  r0_p3_AI0            AT %X24  : TAI;
  r0_p3_AI1            AT %X36  : TAI;
  r0_p3_AI2            AT %X48  : TAI;
  r0_p3_AI3            AT %X60  : TAI;
  r0_p3_AI4            AT %X72  : TAI;
  r0_p3_AI5            AT %X84  : TAI;
  r0_p3_AI6            AT %X96  : TAI;
  r0_p3_AI7            AT %X108 : TAI;
  r0_p3_DO             AT %Y0   : TBIN_12DOIR;
  r0_p3_CNT_OUT1       AT %Y2   : TCNTF2_OUT;
  r0_p3_CNT_OUT2       AT %Y12  : TCNTF2_OUT;
  r0_p3_AO0            AT %Y22  : TAO_TC6;
  r0_p3_AO1            AT %Y32  : TAO_TC6;
  r0_p3_AO2            AT %Y42  : TAO_TC6;
  r0_p3_AO3            AT %Y52  : TAO_TC6;
  r0_p3_PWM8           AT %Y62  : TPWM;
  r0_p3_PWM9           AT %Y68  : TPWM;
  r0_p3_PWM10          AT %Y74  : TPWM;
  r0_p3_PWM11          AT %Y80  : TPWM;
END_VAR
(* -- *)
(* -- *)
VAR_EXTERNAL
END_VAR
(* -- *)

(* ********************************************************************** *)
(* Generovno programem MOSAIC *)
(*  2001-2019 Teco a.s. *)
(* Verze : 1.2 *)
(* DLL Verze : 18.4.4.1 *)
