
//// Ukazka nacteni vice parametru - jako priklad 5, ale postupne se pracuje s polem params[] (srovnej s prikladem 16, ktery pouziva funkcni bloky).
//// Vysledky jsou v promennych params[i].val.

VAR_GLOBAL CONSTANT
    DEVICE_COUNT : USINT := 7;      (* maximalni pocet zarizeni*)
END_VAR

PROGRAM prgMain
  VAR CONSTANT
    IP_Address : STRING := '192.168.1.117:502';
    slaveID : USINT := 1;           // logicke id zarizeni v SM2-MU (zde musi byt id Xtenderu, protoze pracujeme s parametrem 1297)

    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
    PARAM_COUNT : USINT := 6;         (* pocet parametru *)
  END_VAR

  VAR
    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;

    smInit : fb_SMInit;             // instance pro zahajeni komunikace
    smInit_enable : BOOL := true;   // nastavenim na TRUE se zacne provadet smInit (reaguje na nabeznou hranu po zapnuti PLC, po celou dobu vykonavani bloku musi byt enable)

    smPar_enable : BOOL;            // nastavenim na TRUE se pokracuje v komunikaci
    smPar : fb_SMReadWriteParameter;// instance pro vycitani parametru

    smFini : fb_SMFini;             // instance pro ukonceni komunikace

    params : ARRAY [1 .. PARAM_COUNT] OF TParams := [
    (id := 1108, pType := PARAM_FLOAT, cmd := PARAM_READ),
    (id := 1121, pType := PARAM_FLOAT, cmd := PARAM_READ),
    (id := 1143, pType := PARAM_FLOAT, cmd := PARAM_READ),
    (id := 1297, pType := PARAM_FLOAT, cmd := PARAM_READ),
    (id := 1298, pType := PARAM_FLOAT, cmd := PARAM_READ),
    (id := 1307, pType := PARAM_FLOAT, cmd := PARAM_READ)
    ];

    write_phase : BOOL := false;
    val_w : REAL := 12.444;

    i : USINT := 1;
  END_VAR

  VAR_TEMP
    force_fini : BOOL;
    skip_par : BOOL;
  END_VAR

  // pocatecni detekce pritomnych zarizeni
  smInit(enable := smInit_enable, ip := IP_Address, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

  IF smInit.done THEN
    smInit_enable := false;
    smPar_enable := true;
  END_IF;

  IF smPar_enable THEN
    //skip parameter processing during write phase
    skip_par := write_phase AND params[i].cmd = PARAM_READ;

    IF (*i <= PARAM_COUNT AND*) NOT skip_par THEN
      smPar(enable := smPar_enable, ip := IP_Address, chanCode := chanCode, tcp := tcp, params := params[i], DevInfoPtr := ADR(DeviceInfo[slaveID]));
    END_IF;

    // kdyz je blok uspesne vykonan nastavi se parametr enable na 0 kvuli opetovnemu spusteni (enable reaguje na nabeznou hranu)
    IF smPar.err THEN
      smPar_enable := false;
    ELSIF smPar.done OR skip_par THEN

      force_fini := false;
      // nastaveni dalsiho parametru pro cteni/zapis a nastaveni parametru enable na 1 (enable reaguje na nabeznou hranu)
      IF i < PARAM_COUNT THEN
        i := i + 1;

      // po uspesnem cteni hodnot na vsech zarizenich se nastavi jake parametry se budou prepisovat
      // (je mozne nastavit vice parametru k zapisu)
      ELSE //IF i = PARAM_COUNT
        IF NOT write_phase THEN
          params[3].value := val_w;
          params[3].cmd := PARAM_WRITE;
          i := 1;
          write_phase := true;
        ELSE
          smPar_enable := false;
          force_fini := true;
        END_IF;
      END_IF;

      IF force_fini THEN
         //uzavreni TCP spojeni
        smFini(tcp := tcp);
      ELSE
        //zajisteni nabezne hrany pro novy start smPar v pristim cyklu
        smPar(enable := false, params := params[i], DevInfoPtr := ADR(DeviceInfo[slaveID]));
      END_IF;
    END_IF;
  END_IF;

END_PROGRAM


