//// postupne nastavuje vykon na nizsi, pocka, pak opet na vyssi a zase pocka (srovnej s prikladem 17, ktery pouziva funkcni bloky).
//// Stavy automatu nahrazuji stavove promenne xxxx_done z predchozich prikladu.

VAR_GLOBAL CONSTANT
  DEVICE_COUNT : USINT := 7;

  PWCTRL_LOW: UINT := 60;
  PWCTRL_LOW_TIME: TIME := T#10s;//5m;
  PWCTRL_HIGH: UINT := 100;
  PWCTRL_HIGH_TIME: TIME := T#15s;//5m;
END_VAR

TYPE
  Automaton_State :
  (
  AS_Init,
  AS_Pwctrl,
  AS_SetLow,
  AS_SetHigh,
  AS_W4Timer,
  AS_Idle,
  AS_Fini
  );
END_TYPE

PROGRAM prgMain
  VAR CONSTANT
    IP_Address : STRING := '192.168.1.117:502';
    slaveID : USINT := 5;              // id zarizeni

    chanCode : UINT := ETH1_uni0;
    tcp : BOOL := true;
    active : BOOL := true;             // TRUE - aktivni vykon, FALSE - jalovy vykon
    read : BOOL := false;              // TRUE - cteni, FALSE - zapis
  END_VAR

  VAR
    DeviceInfo : ARRAY [1 .. DEVICE_COUNT] OF TDeviceBlockInfo;

    Timer : TON;

    smInit : fb_SMInit;
    smFini : fb_SMFini;
    sm_pc : fb_SMPowerControl;

    pwctrl_value : UINT;
    state : Automaton_State := AS_Init;
    next_state : Automaton_State;
    period : TIME;
  END_VAR

  CASE state OF
    //read device info first
    AS_Init:
      smInit(enable := true, ip := IP_Address, tcp := tcp, chanCode := chanCode, DevInfoPtr := ADR(DeviceInfo), DevInfoSize := DEVICE_COUNT);

      IF smInit.done THEN
        //set low value, no timer state
        pwctrl_value := PWCTRL_LOW;
        period := PWCTRL_LOW_TIME;
        state := AS_Pwctrl;
        next_state := AS_SetHigh;
      END_IF;

    //Set power
    AS_Pwctrl:
      sm_pc(enable := true, ip := IP_Address, tcp := tcp, read := read, chanCode := chanCode, pwctrl := pwctrl_value, active := active, DevInfoPtr := ADR(DeviceInfo[slaveID]));

      IF sm_pc.done OR sm_pc.err THEN
        sm_pc(enable := false, pwctrl := pwctrl_value, DevInfoPtr := ADR(DeviceInfo[slaveID]));
        Timer(IN := 1, PT := period);
        state := next_state;
      END_IF;

    //Set variables for setting high power
    AS_SetHigh:
      pwctrl_value := PWCTRL_HIGH;
      period := PWCTRL_HIGH_TIME;
      state := AS_W4Timer;
      next_state := AS_SetLow;

    //Set variables for setting low power
    AS_SetLow:
      pwctrl_value := PWCTRL_LOW;
      period := PWCTRL_LOW_TIME;
      state := AS_W4Timer;
      next_state := AS_SetHigh;

    //Wait for timer
    AS_W4Timer:
      Timer();
      IF Timer.Q THEN
        Timer(IN := 0);
        state := AS_Pwctrl;
      END_IF;

    AS_Fini:
      smFini(tcp := tcp);

    //do nothing
    AS_Idle:
  END_CASE;

END_PROGRAM



